#ifndef FRAME_HPP
#define FRAME_HPP
///----Log
// Wrote September 26, 1995
//October 5, 1995. Changed max? names to c? names.  Added changed_size_flag
//flag for use by Gosper clock, so it knows not to call RealToPixel
//on the _marks array unless frame->ChagnedSizeFlag() is TRUE.
//October 9, 1995.  Added PixelToReal and two Zoom methods.
//Feb 7, changed RealToPixel and PixelToReal to use pass by reference.
//Added pass by reference versions for converting Point & Vector2
//also do it for POly.  Added _fixedaspect switch.
//------
 /*   Usage
(1) Put "include frame1.hpp" in main Windows program.
(2) Put Frame frame; as a global varialbe in your Windows program.
(3) Use frame.SetRealWindow(Real lox, Real loy, Real hix, Real hiy);
	to change Real window box if desired.  Typically do this in WM_CREATE.
(4) Put frame.SetPixelWindow(LOWORD(lParam), HIWORD(lParam)); in
	WM_SIZE.  This adjusts _cx and _cy to match current pixel window size.
(5) Use frame.RealToPixel(rx,  ry,  ix,  iy)
	to convert Real (rx, ry) to int (ix, iy).
	Or use frame.RealToPixel(vect, pix) or frame.RealToPixel(poly) for,
	respectively, Vector2 vect; Point pix; Poly2 poly.
(6) Use frame.PixelToReal(int ix, int iy, Real rx, Real ry)
	to convert int (ix, iy) [e.g. from a mouse click] to  Real (rx, ry).
	Or use frame.PixelToReal(vect, pix) or frame.PixelToReal(poly) for,
	respectively, Vector2 vect; Point pix; Poly2 poly.
(7) Use frame.ZoomAtPixel(int pixx, int pixy, Real zoomfactor); to zoom in
  or out at a given mouseclick point.  zoomfactor > 1.0 makes image
  smaller, zoomfactor < 1.0 makes image bigger.
(8) SetFixedAspect to TRUE in order to keep circles from changing to
ellipses as you resize Pixel window.  In this case the Pixel window
stays centered on the center, so things seem to move relative to the
window edges.  Use FALSE to keep things fixed in same relative Pixel
window positions, but at the cost of deforming things (circles to ellipses).
*/

#include "types.h" //For the Real type and the windows.h BOOL type

class Frame
{
private:
	int _cx, _cy; //current window size in pixels.
	int _midx, _midy; //Used by RealToPixel().  Pixel center of window.
	Real _realcenterx, _realcentery; //Real coords of center of window.
	Real _realradiusx, _realradiusy;
		//The real value of half the window, origin in center.
	Real _realpixperx, _realpixpery;
		//Length per pixel, same as _mid?/_realradius?
	Real _constx, _consty; //precalculated terms to speed up RealToPixel
	BOOL _changed_size_flag; //
	BOOL _fixed_aspect_flag; //See (8) above.
public:
	Frame(Real radiusx = 10.0, Real radiusy = 8.0);
	int maxx()const{return _cx -1;}
	int maxy()const{return _cy -1;}
	Real realcenterx()const{return _realcenterx;}
	Real realcentery()const{return _realcentery;}
	Real realradiusx()const{return _realradiusx;}
	Real realradiusy()const{return _realradiusy;}
	BOOL ChangedSizeFlag()const{return _changed_size_flag;}
	void SetChangedSizeFlag(BOOL newval){_changed_size_flag = newval;}
	void SetFixedAspect(BOOL truefalse);
	BOOL GetFixedAspect()const{return _fixed_aspect_flag;}
	void SetPixelWindow(int cx, int cy);
	void SetRealWindow(Real lox, Real loy, Real hix, Real hiy);
	/* Usually we like to pass variables by reference if we change them,
		but in the special case of the next two functions we don't do this.
		The reason is that these functions are used inside lots of classes,
		and C++ doesn't always do the right thing if you ask it to generate
		a reference to a class member.  Instead we'll always explicity
		generate the pointer at the coding time with the "&" operator. */
	BOOL RealToPixel(Real rx, Real ry, int *ix, int *iy)const;
	 //Converts real coords to integer pixel coords.  Bails with a FALSE if
		//an integer coord would be >32K or <-32K.
	void PixelToReal(int ix, int iy, Real *rx, Real *ry)const;
		//Convert pixel coords to real coords.
	void Zoom(Real newcenterx, Real newcentery, Real zoomfactor);
	//Sets RealWindow center to args, multiplies radius by zoomfactor.
	void ZoomAtPixel(int pixx, int pixy, Real zoomfactor); //Same
	//as the other Zoom, but calls PixelToReal first.
	void Scroll(Real percentx, Real percenty);
	/*Move the center of RealWindow.  The percent? are between -1.0  and 1.0.
	The amount scrolled is equal the radius times the percent.*/
};

#endif FRAME_HPP